/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jcterm;

import com.jcraft.jcterm.Term;
import java.io.IOException;
import java.io.InputStream;

public abstract class Emulator {
    Term term = null;
    InputStream in = null;
    byte[] buf = new byte[1024];
    int bufs = 0;
    int buflen = 0;
    protected int term_width = 80;
    protected int term_height = 24;
    protected int x = 0;
    protected int y = 0;
    protected int char_width;
    protected int char_height;
    private int region_y2;
    private int region_y1;
    protected int tab = 8;
    private byte[] b2 = new byte[2];
    private byte[] b1 = new byte[1];

    public Emulator(Term term, InputStream in) {
        this.term = term;
        this.in = in;
    }

    public abstract void start();

    public abstract byte[] getCodeENTER();

    public abstract byte[] getCodeUP();

    public abstract byte[] getCodeDOWN();

    public abstract byte[] getCodeRIGHT();

    public abstract byte[] getCodeLEFT();

    public abstract byte[] getCodeF1();

    public abstract byte[] getCodeF2();

    public abstract byte[] getCodeF3();

    public abstract byte[] getCodeF4();

    public abstract byte[] getCodeF5();

    public abstract byte[] getCodeF6();

    public abstract byte[] getCodeF7();

    public abstract byte[] getCodeF8();

    public abstract byte[] getCodeF9();

    public abstract byte[] getCodeF10();

    public abstract byte[] getCodeTAB();

    public void reset() {
        this.term_width = this.term.getColumnCount();
        this.term_height = this.term.getRowCount();
        this.char_width = this.term.getCharWidth();
        this.char_height = this.term.getCharHeight();
        this.region_y1 = 1;
        this.region_y2 = this.term_height;
    }

    byte getChar() throws IOException {
        if (this.buflen == 0) {
            this.fillBuf();
        }
        --this.buflen;
        return this.buf[this.bufs++];
    }

    void fillBuf() throws IOException {
        this.bufs = 0;
        this.buflen = 0;
        this.buflen = this.in.read(this.buf, this.bufs, this.buf.length - this.bufs);
        if (this.buflen <= 0) {
            this.buflen = 0;
            throw new IOException("fillBuf");
        }
    }

    void pushChar(byte foo) throws IOException {
        ++this.buflen;
        this.buf[--this.bufs] = foo;
    }

    int getASCII(int len) throws IOException {
        if (this.buflen == 0) {
            this.fillBuf();
        }
        if (len > this.buflen) {
            len = this.buflen;
        }
        int foo = len;
        while (len > 0) {
            byte tmp;
            if (32 <= (tmp = this.buf[this.bufs++]) && tmp <= 127) {
                --this.buflen;
                --len;
                continue;
            }
            --this.bufs;
            break;
        }
        return foo - len;
    }

    protected void scroll_reverse() {
        this.term.draw_cursor();
        this.term.scroll_area(0, (this.region_y1 - 1) * this.char_height, this.term_width * this.char_width, (this.region_y2 - this.region_y1) * this.char_height, 0, this.char_height);
        this.term.clear_area(this.x, this.y - this.char_height, this.term_width * this.char_width, this.y);
        this.term.redraw(0, 0, this.term_width * this.char_width, this.term_height * this.char_height - this.char_height);
        this.term.draw_cursor();
    }

    protected void scroll_forward() {
        this.term.draw_cursor();
        this.term.scroll_area(0, (this.region_y1 - 1) * this.char_height, this.term_width * this.char_width, (this.region_y2 - this.region_y1 + 1) * this.char_height, 0, -this.char_height);
        this.term.clear_area(0, this.region_y2 * this.char_height - this.char_height, this.term_width * this.char_width, this.region_y2 * this.char_height);
        this.term.redraw(0, (this.region_y1 - 1) * this.char_height, this.term_width * this.char_width, (this.region_y2 - this.region_y1 + 1) * this.char_height);
        this.term.draw_cursor();
    }

    protected void save_cursor() {
    }

    protected void ena_acs() {
    }

    protected void exit_alt_charset_mode() {
    }

    protected void enter_alt_charset_mode() {
    }

    protected void reset_2string() {
    }

    protected void exit_attribute_mode() {
        this.term.resetAllAttributes();
    }

    protected void exit_standout_mode() {
        this.term.resetAllAttributes();
    }

    protected void exit_underline_mode() {
    }

    protected void enter_bold_mode() {
        this.term.setBold();
    }

    protected void enter_underline_mode() {
        this.term.setUnderline();
    }

    protected void enter_reverse_mode() {
        this.term.setReverse();
    }

    protected void change_scroll_region(int y1, int y2) {
        this.region_y1 = y1;
        this.region_y2 = y2;
    }

    protected void cursor_address(int r, int c) {
        this.term.draw_cursor();
        this.x = (c - 1) * this.char_width;
        this.y = r * this.char_height;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void parm_down_cursor(int lines) {
        this.term.draw_cursor();
        this.y += lines * this.char_height;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void parm_left_cursor(int chars) {
        this.term.draw_cursor();
        this.x -= chars * this.char_width;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void parm_right_cursor(int chars) {
        this.term.draw_cursor();
        this.x += chars * this.char_width;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void clr_eol() {
        this.term.draw_cursor();
        this.term.clear_area(this.x, this.y - this.char_height, this.term_width * this.char_width, this.y);
        this.term.redraw(this.x, this.y - this.char_height, this.term_width * this.char_width - this.x, this.char_height);
        this.term.draw_cursor();
    }

    protected void clr_bol() {
        this.term.draw_cursor();
        this.term.clear_area(0, this.y - this.char_height, this.x, this.y);
        this.term.redraw(0, this.y - this.char_height, this.x, this.char_height);
        this.term.draw_cursor();
    }

    protected void clr_eos() {
        this.term.draw_cursor();
        this.term.clear_area(this.x, this.y - this.char_height, this.term_width * this.char_width, this.term_height * this.char_height);
        this.term.redraw(this.x, this.y - this.char_height, this.term_width * this.char_width - this.x, this.term_height * this.char_height - this.y + this.char_height);
        this.term.draw_cursor();
    }

    protected void parm_up_cursor(int lines) {
        this.term.draw_cursor();
        this.y -= lines * this.char_height;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void bell() {
        this.term.beep();
    }

    protected void tab() {
        this.term.draw_cursor();
        this.x = (this.x / this.char_width / this.tab + 1) * this.tab * this.char_width;
        if (this.x >= this.term_width * this.char_width) {
            this.x = 0;
            this.y += this.char_height;
        }
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void carriage_return() {
        this.term.draw_cursor();
        this.x = 0;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void cursor_left() {
        this.term.draw_cursor();
        this.x -= this.char_width;
        if (this.x < 0) {
            this.y -= this.char_height;
            this.x = this.term_width * this.char_width - this.char_width;
        }
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    protected void cursor_down() {
        this.term.draw_cursor();
        this.y += this.char_height;
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
        this.check_region();
    }

    protected void draw_text() throws IOException {
        int h;
        int w;
        this.check_region();
        int rx = this.x;
        int ry = this.y;
        byte b = this.getChar();
        this.term.draw_cursor();
        if ((b & 0x80) != 0) {
            this.term.clear_area(this.x, this.y - this.char_height, this.x + this.char_width * 2, this.y);
            this.b2[0] = b;
            this.b2[1] = this.getChar();
            this.term.drawString(new String(this.b2, 0, 2, "EUC-JP"), this.x, this.y);
            this.x += this.char_width;
            this.x += this.char_width;
            w = this.char_width * 2;
            h = this.char_height;
        } else {
            this.pushChar(b);
            int foo = this.getASCII(this.term_width - this.x / this.char_width);
            if (foo != 0) {
                this.term.clear_area(this.x, this.y - this.char_height, this.x + foo * this.char_width, this.y);
                this.term.drawBytes(this.buf, this.bufs - foo, foo, this.x, this.y);
            } else {
                foo = 1;
                this.term.clear_area(this.x, this.y - this.char_height, this.x + foo * this.char_width, this.y);
                this.b1[0] = this.getChar();
                this.term.drawBytes(this.b1, 0, foo, this.x, this.y);
            }
            this.x += this.char_width * foo;
            w = this.char_width * foo;
            h = this.char_height;
        }
        this.term.redraw(rx, ry - this.char_height, w, h);
        this.term.setCursor(this.x, this.y);
        this.term.draw_cursor();
    }

    private void check_region() {
        if (this.x >= this.term_width * this.char_width) {
            this.x = 0;
            this.y += this.char_height;
        }
        if (this.y > this.region_y2 * this.char_height) {
            while (this.y > this.region_y2 * this.char_height) {
                this.y -= this.char_height;
            }
            this.term.draw_cursor();
            this.term.scroll_area(0, this.region_y1 * this.char_height, this.term_width * this.char_width, (this.region_y2 - this.region_y1) * this.char_height, 0, -this.char_height);
            this.term.clear_area(0, this.y - this.char_height, this.term_width * this.char_width, this.y);
            this.term.redraw(0, 0, this.term_width * this.char_width, this.region_y2 * this.char_height);
            this.term.setCursor(this.x, this.y);
            this.term.draw_cursor();
        }
    }
}

